
#ifndef SEP_ATP_UTIL_FUNCS_H
#define SEP_ATP_UTIL_FUNCS_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

//#include "MW_ATP_defines.h"

/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 07 10:27:43 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MW_ATP_UTIL_funcs.h#1:incl:1
   *  \author arield
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/******** Defines **********/
#define ATP_EXIT_TEST_AFTER_FAILURE  NO_DEBUG
#define NO_DEBUG 1
#define LOW_DEBUG 2
#define HIGH_DEBUG 3
#define TST_FAIL 	                     1

#define TST_ATP_CHECK_ERROR_RETURN(CurrentResult,FunName,LocalTestName,MainTestName)\
if((ATP_TST_CheckErrorReturn(CurrentResult,(DxChar_t*)FunName,(DxChar_t*)LocalTestName,(DxChar_t*)MainTestName) == TST_FAIL))\
  {goto EXIT_ON_ERROR;}


void ATP_LOG( DxUint8_t level ,  const char *format, ...);

#define ATP_LOG_TST_PRINT(args) (ATP_LOG args)

/*****************************************************************************
* Function Name:
*  ATP_TST_CheckErrorReturn
*
* Inputs:
*  DxUint32_t  TST_ErrorRet - The return value of the checked function
*  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
*  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
*  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
*
* Outputs:
*  DxUint8_t - Function error return
*
* Description:
* This function Is a utility function to save up some space
* this function returns the appropriate printing for a checked function
* If the operation has succeeded of failed the appropriate printing and return value
*
******************************************************************************/
DxError_t ATP_TST_CheckErrorReturn(DxError_t  TST_ErrorRet,
                                   char       TST_FuncName[TST_FUNC_STRING_LEN],
                                   char       TST_SubTestName[TST_FUNC_STRING_LEN],
                                   char       TST_MasterTestName[TST_FUNC_STRING_LEN]);

/*****************************************************************************
 * Function Name:
 * 	TST_CheckErrorReturn 
 * 
 * Inputs:
 * 	DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char 	 TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char 	 TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 * 	DxError_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation had Succeeded of failed	the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t TST_CheckErrorReturn(DxError_t TST_ErrorRet, char*  TST_FuncName);

#ifdef __cplusplus
}
#endif

#endif /*SEP_ATP_UTIL_FUNCS_H*/

